<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAsset;

class QueryAssetsRequest extends \Google\Model
{
  /**
   * @var string
   */
  public $jobReference;
  protected $outputConfigType = QueryAssetsOutputConfig::class;
  protected $outputConfigDataType = '';
  public $outputConfig;
  /**
   * @var int
   */
  public $pageSize;
  /**
   * @var string
   */
  public $pageToken;
  /**
   * @var string
   */
  public $readTime;
  protected $readTimeWindowType = TimeWindow::class;
  protected $readTimeWindowDataType = '';
  public $readTimeWindow;
  /**
   * @var string
   */
  public $statement;
  /**
   * @var string
   */
  public $timeout;

  /**
   * @param string
   */
  public function setJobReference($jobReference)
  {
    $this->jobReference = $jobReference;
  }
  /**
   * @return string
   */
  public function getJobReference()
  {
    return $this->jobReference;
  }
  /**
   * @param QueryAssetsOutputConfig
   */
  public function setOutputConfig(QueryAssetsOutputConfig $outputConfig)
  {
    $this->outputConfig = $outputConfig;
  }
  /**
   * @return QueryAssetsOutputConfig
   */
  public function getOutputConfig()
  {
    return $this->outputConfig;
  }
  /**
   * @param int
   */
  public function setPageSize($pageSize)
  {
    $this->pageSize = $pageSize;
  }
  /**
   * @return int
   */
  public function getPageSize()
  {
    return $this->pageSize;
  }
  /**
   * @param string
   */
  public function setPageToken($pageToken)
  {
    $this->pageToken = $pageToken;
  }
  /**
   * @return string
   */
  public function getPageToken()
  {
    return $this->pageToken;
  }
  /**
   * @param string
   */
  public function setReadTime($readTime)
  {
    $this->readTime = $readTime;
  }
  /**
   * @return string
   */
  public function getReadTime()
  {
    return $this->readTime;
  }
  /**
   * @param TimeWindow
   */
  public function setReadTimeWindow(TimeWindow $readTimeWindow)
  {
    $this->readTimeWindow = $readTimeWindow;
  }
  /**
   * @return TimeWindow
   */
  public function getReadTimeWindow()
  {
    return $this->readTimeWindow;
  }
  /**
   * @param string
   */
  public function setStatement($statement)
  {
    $this->statement = $statement;
  }
  /**
   * @return string
   */
  public function getStatement()
  {
    return $this->statement;
  }
  /**
   * @param string
   */
  public function setTimeout($timeout)
  {
    $this->timeout = $timeout;
  }
  /**
   * @return string
   */
  public function getTimeout()
  {
    return $this->timeout;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(QueryAssetsRequest::class, 'Google_Service_CloudAsset_QueryAssetsRequest');
